// (c) 1999 - 2025 OneSpan North America Inc. All rights reserved.


/////////////////////////////////////////////////////////////////////////////
//
//
// This file is example source code. It is provided for your information and
// assistance. See your licence agreement for details and the terms and
// conditions of the licence which governs the use of the source code. By using
// such source code you will be accepting these terms and conditions. If you do
// not wish to accept these terms and conditions, DO NOT OPEN THE FILE OR USE
// THE SOURCE CODE.
//
// Note that there is NO WARRANTY.
//
//////////////////////////////////////////////////////////////////////////////


import MSSOrchestration

class ServerCallHandler {
    var progressDialog: UIView?
    var orchestrator: Orchestrator?
    weak var viewController: UIViewController?

    func sendCommandToServer(_ command: String, actionOnExitAlert: (() -> Void)? = nil) {
        print("sendCommandToServer:", command)
        let content = [ConfigurableConstants.serverCommandKey: command]
        
        HTTPUtils.performJsonRequestOnServerUrl(serverURL: ConfigurableConstants.URLs.endpoint, content: content, debug: true) { command in
            if let command = command {
                // Handle received server command
                self.orchestrator?.execute(command: command)
                return
            }
            
            UIUtils.hideProgress(self.progressDialog)
            if let viewController = self.viewController {
                UIUtils.displayAlert(controller: viewController,
                                     title: "dialog_error_title".localized,
                                     message: "dialog_error_content_sending".localized,
                                     dismissAction: actionOnExitAlert)
            }
        }
    }
}
